<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model 
{

    protected $table = 'products_variants';
    public $timestamps = true;
    protected $fillable = array('sku', 'gtin', 'on_backorder', 'on_hand', 'available_on_demand', 'weight', 'width', 'height', 'depth');
    protected $visible = array('sku', 'gtin', 'on_backorder', 'on_hand', 'available_on_demand', 'weight', 'width', 'height', 'depth');

    public function variant_images()
    {
        return $this->hasManyThrough('App\Models\ProductImage');
    }

    public function variantoption()
    {
        return $this->hasManyThrough('App\Models\ProductOption');
    }

    public function variantsetting()
    {
        return $this->hasManyThrough('App\Models\ProductProperty');
    }

}